package fr.asip.cps3.exemple.vues.menus;

import java.awt.event.ActionListener;
import fr.asip.cps3.exemple.modele.objets.Slot;

/**
 * Classe modlisant un item de menu de type Slot
 *
 */
public class ItemMenuSlot extends ItemMenu {
	
	private static final long serialVersionUID = 7140793894082632745L;
	
	/**
	 * Slot associ  l'item de menu
	 */
	private Slot slot;

	/**
	 * Constructeur  5 arguments 
	 * @param slot
	 * @param idParent Identifiant du menu parent
	 * @param enable Boolen attestant du caractre actionnable de l'item de menu
	 * @param visible Boolen attestant du caractre visible de l'item de menu
	 * @param ecouteur Ecouteur positionn sur l'item de menu
	 */
	public ItemMenuSlot(Slot slot,String idParent, boolean enable, boolean visible, ActionListener ecouteur) {
		super(idParent+",", idParent, "", enable, visible, ecouteur);
		this.slot = slot;
		if(slot != null) {
			setId(getIdParent()+","+slot.getIdSlot());
			setText(slot.getLibelle());
		}
	}

	/**
	 * Accesseur
	 * @return Slot associ  l'item de menu
	 */
	public Slot getSlot() {
		return slot;
	}


	
}
